/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import terrablender.DimensionTypeTags;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.core.TerraBlender;
import terrablender.worldgen.IExtendedBiomeSource;
import terrablender.worldgen.IExtendedNoiseGeneratorSettings;
import terrablender.worldgen.IExtendedParameterList;

public class LevelUtils {
    public static void initializeOnServerStart(MinecraftServer server) {
        class_5455.class_6890 registryAccess = server.method_30611();
        class_5285 worldGenSettings = server.method_27728().method_28057();
        for (Map.Entry entry : worldGenSettings.method_28609().method_29722()) {
            class_5363 stem = (class_5363)entry.getValue();
            LevelUtils.initializeBiomes((class_5455)registryAccess, (class_6880<class_2874>)stem.method_29566(), (class_5321<class_5363>)((class_5321)entry.getKey()), stem.method_29571(), worldGenSettings.method_28028());
        }
    }

    public static boolean shouldApplyToChunkGenerator(class_2794 chunkGenerator) {
        return chunkGenerator instanceof class_3754 && LevelUtils.shouldApplyToBiomeSource(chunkGenerator.method_12098());
    }

    public static boolean shouldApplyToBiomeSource(class_1966 biomeSource) {
        return biomeSource instanceof class_4766;
    }

    public static RegionType getRegionTypeForDimension(class_6880<class_2874> dimensionType) {
        if (dimensionType.method_40220(DimensionTypeTags.NETHER_REGIONS)) {
            return RegionType.NETHER;
        }
        if (dimensionType.method_40220(DimensionTypeTags.OVERWORLD_REGIONS)) {
            return RegionType.OVERWORLD;
        }
        return null;
    }

    public static void initializeBiomes(class_5455 registryAccess, class_6880<class_2874> dimensionType, class_5321<class_5363> levelResourceKey, class_2794 chunkGenerator, long seed) {
        if (!LevelUtils.shouldApplyToChunkGenerator(chunkGenerator)) {
            return;
        }
        RegionType regionType = LevelUtils.getRegionTypeForDimension(dimensionType);
        class_3754 noiseBasedChunkGenerator = (class_3754)chunkGenerator;
        class_5284 generatorSettings = (class_5284)noiseBasedChunkGenerator.method_41541().comp_349();
        class_4766 biomeSource = (class_4766)chunkGenerator.method_12098();
        IExtendedBiomeSource biomeSourceEx = (IExtendedBiomeSource)biomeSource;
        if (regionType == null) {
            return;
        }
        ((IExtendedNoiseGeneratorSettings)generatorSettings).setRegionType(regionType);
        class_6544.class_6547 parameters = biomeSource.field_34498;
        IExtendedParameterList parametersEx = (IExtendedParameterList)parameters;
        parametersEx.initializeForTerraBlender(registryAccess, regionType, seed);
        class_2378 biomeRegistry = registryAccess.method_30530(class_2378.field_25114);
        ImmutableList.Builder builder = ImmutableList.builder();
        Regions.get(regionType).forEach(region -> region.addBiomes((class_2378<class_1959>)biomeRegistry, pair -> builder.add((Object)biomeRegistry.method_40290((class_5321)pair.getSecond()))));
        biomeSourceEx.appendDeferredBiomesList((List<class_6880<class_1959>>)builder.build());
        TerraBlender.LOGGER.info(String.format("Initialized TerraBlender biomes for level stem %s", levelResourceKey.method_29177()));
    }
}

